<title>Post Job - Best Leearning</title>
@extends('user.layouts.master')
@section('css')
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="{{ asset('resources/css/jobcreate.css') }}">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
@endsection
@section('user-content')

    @if(session('job_success'))
        <div class="alert alert-success" style="font-weight:bold;">
            <i class="fas fa-check"></i>
            <span id="jobSuccessMessage" class="ms-3">Job Post Success</span>
            <button type="button" class="close" onclick="closeThisMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    
    @if(session('job_error'))
        <div class="alert alert-danger" style="font-weight:bold;">
            <i class="far fa-frown"></i>
            <span id="jobErrorMessage" class="ms-2">Insufficient Balance</span>
            <button type="button" class="close" onclick="closeThisMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card mt-2">
        <div class="card-header">
            <h4 class="card-title text-center" style="font-weight: 500; color: #2ECC71; font-size: 22px;">Post New Job</h4>
        </div>
        <div class="step-container-main">
            <form class="myPostWizard" id="job_creat_form" action="{{ route('user.job-post') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" id="job_fee" value="{{ $job_fee->fee }}">
                <input type="hidden" id="minimum_cost" value="{{min_job_fee()}}">
                
               <div class=>

                    <div style="text-align: center">
                        <div class="wrapper-step-bar-main">
                            <ul class="step-bar-single">
                                <li onclick="nextStep(1)" id="step-top-1" class="step-top-selector active"><span class="tab-title">Select Location</span></li>
                                <li onclick="nextStep(2)" id="step-top-2" class="step-top-selector"><span class="tab-title">Select Category</span></li>
                                <li id="step-top-3" class="step-top-selector"><span class="tab-title">Job Information</span></li>
                                <li id="step-top-4" class="step-top-selector"><span class="tab-title">Budget &amp; Setting</span></li>
                            </ul>
                        </div>
                    </div>

                    <br>
        
                    <!-- STEP 1-->
                    <div id="step-1" class="step-container" style="display:block">
                        <p class="tab-title-header">Select Location</p>
                        <div class="zone_list">
                            @foreach($continents as $key=>$continent)
                                @if($key == 0)
                                    @php
                                        $cnt_id = $continent->id;
                                    @endphp
                                @endif
                                <div class="zone-item-div">
                                    <input type="radio" class="continent-input" name="continent" value="{{$continent->id}}" id="radio-int-{{ $continent->id }}" @if($key == 0) checked="" @endif>
                                    <label class="zone-item" for="radio-int" id="radio-int-label-{{ $continent->id }}" onclick="getCountry('{{ $continent->id }}')">{{$continent->name}}</label>
                                </div>
                            @endforeach
                            
                        </div>
        
                        <div class="form-group">
                            <label class="text-sm font-weight-medium text-red mb-3" style="border: 2px solid #FF9E00 !important;padding: 4px;border-radius: 5px;margin-top: 16px;"> *Select countries you want to hide from the selected zone <span class="text-blue">(optional)</span></label>
                          <p class="text-blue font-weight-bold" id="ccHideNotice" style="display:none">If you want to hide any country , than you will pay extra $0 for per country !</p>  
                          <div class="btn-checkboxes btn-checkboxes--small-gutter row exclude-countries int" style="display: block;" id="continent-country-area">
                                @if(continent_country($cnt_id)->count() > 0)
                                    @foreach(continent_country($cnt_id) as $c_key=>$c_country)
                                        <div class="col001">
                                            <div class="col022">
                                                <input type="checkbox" id="ex-int-{{$c_country->country_id}}" class="custom-control-input exclude-country" name="country_id[]" value="{{$c_country->country_id}}">
                                                <label for="ex-int-{{$c_country->country_id}}" class="exclude-country-label  bg-gray border-0">{{country($c_country->country_id)}}</label>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <div class="step-button-container">
                            <button type="button" onclick="nextStep(2)" class="step-button">
                              Next
                             <span class="next-icon"><i class="fas fa-chevron-right"></i></span>
                            </button>
                        </div>
                    </div>
        
                    <!-- STEP 2-->
                    <div id="step-2" class="step-container">
                        <p class="tab-title-header">Select Category</p>
        
                            @foreach ($categorys as $key=>$category)
                                @if($key == 0)
                                    @php
                                        $cat_id = $category->id;
                                    @endphp
                                @endif
                                <div class="category-item-div cparent-{{ $category->id }} m-0" onclick="getSubCategory('{{ $category->id }}')">
                                    <input type="radio" name="category_id" value="{{ $category->id }}" id="radio-parent-{{ $category->id }}" @if($key == 0) checked="" @endif">
                                    <label class="zone-item" for="radio-parent-{{ $category->id }}">{{ $category->name }}</label>
                                </div>
                            @endforeach
                        
        
                        <hr class="red-hr">
                        <h4 class="text-green">Select the subcategory</h4>
        
                        <div id="sub-category-area">
                            @if(sub_categorys($cnt_id)->count() > 0)
                                @foreach(sub_categorys($cnt_id) as $c_key=>$sub_category)
                                    <div class="category-item-div cchild-item {{$sub_category->id}} m-0" onclick="selectSubCategory('{{ $sub_category->id }}', '{{ $sub_category->minimum_cost }}')">
                                        <input data-cpc="0.02" data-upload="0" type="radio" name="sub_category" value="{{$sub_category->id}}" id="radio-child-{{$sub_category->id}}"><label class="zone-item" for="radio-child-{{$sub_category->id}}">{{$sub_category->name}}</label>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        
                        <div class="step-button-container">
                            <button type="button" onclick="nextStep(1)" class="step-button">
                                <span class="back-icon"><i class="fas fa-chevron-left"></i></span>
                                Back
                            </button>
                            <button type="button" onclick="nextStep(3)" id="step-button-category-next" class="step-button step-button-disabled" disabled="">
                                Next
                                <span class="next-icon"><i class="fas fa-chevron-right"></i></span>
                            </button>
                        </div>
                    </div>
        
        
                    <!-- STEP 3-->
                    <div id="step-3" class="step-container">
                        <p class="tab-title-header">Job Information</p>
                        
                        <style>
                            #count_message_title {
                                background-color: smoke;
                                margin-top: -33px;
                                margin-right: 5px;
                            }
                            .post-job-work-step:first-child .stpsCloseBtn {
                                display:none;
                            }
                            .post-job-work-step:last-child {
                                display:none;
                            }
                        </style>
            
                        <div class="form-group mb-5">
                            <p for="jobTitle" style="color:#0f7235">&bullet; Write an accurate job Title</p>
                            <input type="text" class="form-control" id="jobTitle" name="title" placeholder="Enter your job title" maxlength="25" oninput="limitInput(this, 25)" required="">
                            <div class="input-group-append" style="float:right">
                               <span class="label label-default text-red text-muted" id="count_message_title">0 / 25</span>
                           </div>
                        </div>
            
                        <div class="form-group" id="task_need_to_completed_area">
                            <p style="color:#0f7235">&bullet; What specific tasks need to be Completed</p>
                            <div class="task-steps-container">
                                <div class="text-label-join mb-5 bg-softer">
                                    <label for="work1" class="step_labelx">Step 1 [ Max 150 Character ]</label>
                                    <textarea class="form-control" name="specific_task[]" id="specific_task" maxlength="150" oninput="limitTextarea(this, 150); updateCharCount(1)" cols="30" rows="5"></textarea>
                                </div>
                            </div>
                            <button id="addStepsButton" type="button" style="margin-top: -20px" class="btn btn-icon btn-facebook bttn" onclick="addTaskNeededCompleteArea()"><span class="btn-inner--icon"><i class="fas fa-plus"></i></span> Add Steps</button>
                        </div>

                        <div class="form-group">
                            <p style="color:#4B0082">&bullet; Required proof the job was Completed </p>
                            <div class="text-label-join mb-5 bg-softer">
                                <textarea class="form-control" name="required_proof" id="proof" cols="30" rows="5"></textarea>
                            </div>
                        </div>
            
                        <div class="form-group bg-softer">
                            <p style="color:#136e36;margin-bottom:0">&bullet; Thumbnail Image (optional)</p>
                            <input type="file" style="display: none" name="thumbnail" id="screen_shot_select_image" accept="image/x-png,image/jpg,image/jpeg" onchange="readURL();" lang="en">
                            <small class="text-danger" id="file-error"></small>
                            <label style="border: 1px solid gray; border-radius: 5px; padding: 5px; margin-bottom: 0; cursor: pointer;" class="custom-file-label-drop" for="screen_shot_select_image"><i class="fas fa-camera"></i> Select image</label>
                            <div class="gallery-img">
                            <img class="mt-2" id="screen_shot_show_image" src="#" style="display:none; max-width: 95%;" />
                           </div>
                        </div>

                
                        <div class="step-button-container">
                            <button type="button" onclick="nextStep(2)" class="step-button">
                                <span class="back-icon"><i class="fas fa-chevron-left"></i></span>
                                Back
                            </button>
                            <button type="button" onclick="nextStep(4)" id="step-button-category-next-info" class="step-button step-button-disabled" disabled="">
                                Next
                                <span class="next-icon"><i class="fas fa-chevron-right"></i></span>
                            </button>
                        </div>
                    </div>
            
        
                    <!-- STEP 4-->
                    <div id="step-4" class="step-container">
                        <p class="tab-title-header">Budget &amp; Setting</p>
                    
                        <div style="margin-top: 20px">
                                    <p id="inWorker" class="font-weight-bold text-red ml-3"><i class="fas fa-exclamation-triangle"></i>-Please increase your worker!</p>
                                
                                 <!--<p></p><p class="font-weight-bold text-blue" id="jpySshot" style="display: none">--For Youtube Minimum 1 Screenshot Mandatory</p>-->
                    
                                <div class="row">
                                    <div class="col-md-6" style="padding: 30px; ">
                                        <div class="row">
                                            <h5 label="" class="col-sm-6" style="color:#27954f;"><b>Worker Need</b></h5>
                                            <div class="col-sm-6">
                                                <input type="number" class="form-control" name="worker_need" id="worker_need" value="5" min="1" onchange="chnageWorkerNeed()" onkeyup="chnageWorkerNeed()">
                                            </div>
                                        </div>
                    
                                        <div class="row" style="margin-top: 30px">
                                            <h5 label="" class="col-sm-6" style="color:#27954f;"><b>Each worker Earn</b></h5>
                                            <div class="col-sm-6">
                                                <input type="hidden" class="form-control" id="each_worker_min_earn" value="0">
                                                <input type="number" class="form-control" name="each_worker_earn" id="each_worker_earn" step="0.0001" value="0" min="0" onchange="chnageWorkerEarn()" onkeyup="chnageWorkerEarn()">
                                            </div>
                                             <small class="text-muted text-red font-weight-600" id="each_worker_min_earn_alert" style="margin-top: 8px; margin-left: 2%; display: block;"></small>
                                        </div>
                                        
                                        <div class="row" style="margin-top: 30px">
                                            <h5 label="" class="col-sm-6" style="color:#27954f;"><b>Require Screenshots</b></h5>
                                            <div class="col-sm-6">
                                                <input type="hidden" class="form-control" id="old_required_screenshots_cost" step="0.0001" value="0" min="0" max="7">
                                                <input type="number" class="form-control" name="required_screenshots" id="required_screenshots" onchange="chnageScreenShoot('{{screenshoot_charge()}}')" onkeyup="chnageScreenShoot('{{screenshoot_charge()}}')" value="0" min="0" max="7">
                                            </div>
                                        </div>
                    
                                        <div class="row" style="margin-top: 30px">
                                            <h5 label="" class="col-sm-6 " style="color:#27954f;"><b>Estimated Day</b></h5>
                                            <div class="col-sm-6">
                                                <input type="number" class="form-control" name="estimited_day" value="3" min="1">
                                            </div>
                                        </div>
                                    </div>
                    
                    
                                    <div class="col-md-6" style="text-align: center;padding: 10px">
                                        <div class="block_balance_board">
                                            <h5 style="color:#000;font-size: 13px;font-weight: bold;">Estimated Job Cost</h5>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text drk_white_theme" style="font-size:20px">$</span>
                                                </div>
                                                <input type="number" style="color:#22ab59;" class="form-control" readonly name="budget" id="budget" value="0" min="0">
                                            </div>
                                            <p class="font-weight-bold text-red spend1" style="font-size: 14px;" id="mCost">Minimum Spend: ${{ number_format(min_job_fee(),2) }}</p>
                                            <p></p>
                                            <div class="text-right"><a href="{{route('mine')}}" class="btn btn-success btn-sm text-dark" id="postInfo" style="background:#fec30f;border:none;display:none;">Please! Deposit</a></div>
                                        </div>
                                    </div>
                                </div>

                            <div class="step-button-container">
                                <button type="button" onclick="nextStep(3)" class="step-button">
                                    <span class="back-icon"><i class="fas fa-chevron-left"></i></span>
                                    Back
                                </button>
                                <button type="button" onclick="submitJob()" class="btn btn-outline-primary btn-sm bttn" id="postSubmitNew" style="border-radius: 30px;"><i class="fas fa-check"></i> Submit Post</button>
                            </div>
                        </div>
                    </div>
               <!-- </div>-->
            </form>
        </div>
    </div>
@endsection
@section('js')
<!-- Add this in your HTML file -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
        function nextStep(current) {
            if (current === 1) {
                $('#step-top-4').removeClass('active');
                $('#step-top-3').removeClass('active');
                $('#step-top-2').removeClass('active');
                $('#step-top-1').addClass('active');
            } else if (current === 2) {
                $('#step-top-4').removeClass('active');
                $('#step-top-3').removeClass('active');
                $('#step-top-2').addClass('active');
                $('#step-top-1').addClass('active');
            } else if (current === 3) {
                $('#step-top-4').removeClass('active');
                $('#step-top-3').addClass('active');
                $('#step-top-2').addClass('active');
                $('#step-top-1').addClass('active');
            } else if (current === 4) {
                $('#step-top-4').addClass('active');
                $('#step-top-3').addClass('active');
                $('#step-top-2').addClass('active');
                $('#step-top-1').addClass('active');
            }
        
            if (current === 1) {
                $('.step-container').css('display', 'none');
                $('#step-' + current).css('display', 'block');
            } else if (current === 2) {
                $('.step-container').css('display', 'none');
                $('#step-' + current).css('display', 'block');
            } else if (current === 3) {
                $('.step-container').css('display', 'none');
                $('#step-' + current).css('display', 'block');
            } else if (current === 4) {
                $('.step-container').css('display', 'none');
                $('#step-' + current).css('display', 'block');
            }
        }
    
        function setAccount(account_id){
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "{{ route('user.deposit-account-info') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    account_id: account_id,
                },
                success:function(data) {
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: '+data['account_no']);
                    $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }

        function chnageLocationZone(){
            var location_zone = $('#location_zone').val();
            $.ajax({
                url: "{{ route('user.get-country') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    location_zone: location_zone,
                },
                success:function(data) {
                    $('#country').html(data);
                },
            });
        }

        function getCountry(continet_id){
            $(".continent-input").prop('checked', false);
            $("#radio-int-"+continet_id).prop('checked', true);
            
            $.ajax({
                url: "{{ route('user.get-continent-country') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    continet_id: continet_id,
                },
                success:function(data) {
                    $('#continent-country-area').html(data);
                },
            });
        }
        
        function getSubCategory(category_id){
            $.ajax({
                url: "{{ route('user.get-sub-categorys') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    category_id: category_id,
                },
                success:function(data) {
                    console.log(data);
                    $('#sub-category-area').html(data);
                },
            });
        }

        function chnageSubCategory(){
            var sub_category = $('#sub_category').val();
            var worker_need = parseFloat($('#worker_need').val());
            var job_fee = parseInt($('#job_fee').val());
            $.ajax({
                url: "{{ route('user.get-sub-category-price') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    sub_category: sub_category,
                },
                success:function(data) {
                    var old_required_screenshots_cost = parseFloat($('#old_required_screenshots_cost').val());
                    var minimum_cost = parseFloat(data);
                    // $('#minimum_cost').val(minimum_cost);
                    $('#each_worker_earn').val(minimum_cost);
                    $('#each_worker_min_earn').val(minimum_cost);
                    var total_cost = parseFloat(minimum_cost * worker_need);
                    var fee = parseFloat((parseFloat(total_cost) * parseFloat(job_fee)) / 100);
                    var total = (total_cost + fee + old_required_screenshots_cost).toFixed(4);
                    $('#budget').val(total);
                },
            });
        }

        function chnageWorkerNeed(){
            var old_required_screenshots_cost = parseFloat($('#old_required_screenshots_cost').val());
            var job_fee = parseInt($('#job_fee').val());
            var worker_need = parseFloat($('#worker_need').val());
            var each_worker_earn = parseFloat($('#each_worker_earn').val());
            var total_cost = parseFloat(each_worker_earn * worker_need);
            var fee = parseFloat((parseFloat(total_cost) * parseFloat(job_fee)) / 100);
            var total = (total_cost + fee + old_required_screenshots_cost).toFixed(4);
            $('#budget').val(total);
        }

        function chnageWorkerEarn() {
            var old_required_screenshots_cost = parseFloat($('#old_required_screenshots_cost').val());
            var job_fee = parseInt($('#job_fee').val());
            var worker_need = parseFloat($('#worker_need').val());
            var each_worker_earn = parseFloat($('#each_worker_earn').val());
           
            var each_worker_min_earn = parseFloat($('#each_worker_min_earn').val()) || 0;
        
            var total_cost = parseFloat(each_worker_earn * worker_need);
            var fee = parseFloat((parseFloat(total_cost) * parseFloat(job_fee)) / 100);
            var total = (total_cost + fee + old_required_screenshots_cost).toFixed(4);
            $('#budget').val(total);
        
            if (each_worker_earn < each_worker_min_earn) {
                $('#each_worker_min_earn_alert').html('Minimum Task Price Is $' + each_worker_min_earn);
                //$('#postSubmitNew').prop('disabled', true); // Disable the button
            } else {
                $('#each_worker_min_earn_alert').html('');
                //$('#postSubmitNew').prop('disabled', false); // Enable the button
            }
        }

        function addTaskNeededCompleteArea() {
            const $lastStep = $('.task-steps-container .bg-softer:last');
        
            const nextStep = $lastStep.index() + 2; 
        
            const $newStep = $lastStep.clone();
            const $textarea = $newStep.find('textarea');
            const $label = $newStep.find('.step_labelx');
        
            $textarea.prop('id', `specific_task${nextStep}`);
            $textarea.val('');
        
            $label.text(`Step ${nextStep} [ Max 150 Character ]`); 
            
            $label.append(' ');
            $label.append('<i class="stpsCloseBtn fa fa-times-circle" aria-hidden="true" onclick="deleteTaskStep(this)"></i>');
        
            $lastStep.after($newStep);
        }
        
        function deleteTaskStep(button) {
            $(button).closest('.bg-softer').remove();
        }


        function submitJob(){
            var minimum_cost = parseFloat($('#minimum_cost').val());
            var budget = parseFloat($('#budget').val());
            
            
            if(minimum_cost > budget){
                $('#job_cost_alert').html('Minimum cost should be $'+minimum_cost);
                $('#job_cost_alert').addClass('text-danger');
                $('#budget').addClass('over-balance');
            }else{
                $('#job_cost_alert').html('');
                $('#job_cost_alert').removeClass('text-danger');
                $('#budget').removeClass('over-balance');
                $('#job_creat_form').submit();
            }
        }
        
        
        function deleteCompleteArea(step){
            $('#another_area_'+step).remove();
        }


        function chnageWorker(){
            var worrker_need = $('#worrker_need').val();
            if(worrker_need == '' || !$.isNumeric(worrker_need)){
                worrker_need = parseInt('0');
            }
        }

        function chnageScreenShoot(charge){
            var old_required_screenshots_cost = parseFloat($('#old_required_screenshots_cost').val());
            var required_screenshots = parseInt($('#required_screenshots').val());
            if(required_screenshots == '' || !$.isNumeric(required_screenshots)){
                required_screenshots = parseInt('0');
            }
            if(required_screenshots > 7){
                $('#required_screenshots').val(3);
            }
            var sh_charge = parseFloat(charge) * required_screenshots;
            var budget = parseFloat($('#budget').val());
            var total = ((budget - old_required_screenshots_cost) + sh_charge).toFixed(4);
            $('#budget').val(total);
            $('#old_required_screenshots_cost').val(sh_charge);
        }
        
   
        
        function selectSubCategory(subcat_id, minimum_cost){
            $('#step-button-category-next').prop('disabled', false);
            $('#step-button-category-next').removeClass('step-button-disabled');
            
            var worker_need = parseFloat($('#worker_need').val());
            var job_fee = parseInt($('#job_fee').val());
            var old_required_screenshots_cost = parseFloat($('#old_required_screenshots_cost').val());
            $('#each_worker_earn').val(minimum_cost);
            $('#each_worker_min_earn').val(minimum_cost);
            var total_cost = parseFloat(minimum_cost * worker_need);
            var fee = parseFloat((parseFloat(total_cost) * parseFloat(job_fee)) / 100);
            var total = (total_cost + fee + old_required_screenshots_cost).toFixed(4);
            $('#budget').val(total);
            
            $('#step-top-3').attr('onClick', 'nextStep(3);');
        }
        
        
        $(document).on('change', '#jobTitle', function () {
            titleAdded = true;
            if (titleAdded && proofAdded && workReqAdded) {
                $('#step-button-category-next-info').prop('disabled', false);
                $('#step-button-category-next-info').removeClass('step-button-disabled');
            } else {
                $('#step-button-category-next-info').prop('disabled', true);
                $('#step-button-category-next-info').addClass('step-button-disabled');
            }
        });
        
        $(document).on('change', '#work1', function () {
            if ($(this).val() !== " ") {
                workReqAdded = true;
            } else {
                workReqAdded = false;
            }
            if (titleAdded && proofAdded && workReqAdded) {
                $('#step-button-category-next-info').prop('disabled', false);
                $('#step-button-category-next-info').removeClass('step-button-disabled');
            } else {
                $('#step-button-category-next-info').prop('disabled', true);
                $('#step-button-category-next-info').addClass('step-button-disabled');
            }
        });
        
        $(document).on('change', '[name=workProve]', function () {
            if ($(this).val() !== " ") {
                proofAdded = true;
            } else {
                proofAdded = false;
            }
            if (titleAdded && proofAdded && workReqAdded) {
                $('#step-button-category-next-info').prop('disabled', false);
                $('#step-button-category-next-info').removeClass('step-button-disabled');
            } else {
                $('#step-button-category-next-info').prop('disabled', true);
                $('#step-button-category-next-info').addClass('step-button-disabled');
            }
        });
        
        
        var text_max = 25;
        $('#count_message_title').html('0 / ' + text_max );
        $('#jobTitle').keyup(function() {
            var text_length = $('#jobTitle').val().length;
            var text_remaining = text_max - text_length;
            $('#count_message_title').html(text_length + ' / ' + text_max);
        });
        
        $("#jobTitle").focusout(function(){
            var jobTitle = $('#jobTitle').val();
            var specific_task = $('#specific_task').val();
            var proof = $('#proof').val();
            if(jobTitle !== "" && specific_task !== "" && proof !== ""){
                $('#step-button-category-next-info').prop('disabled', false);
                $('#step-button-category-next-info').removeClass('step-button-disabled');
                
                $('#step-top-4').attr('onClick', 'nextStep(4);');
            }else {
                $('#step-button-category-next-info').prop('disabled', true);
                $('#step-button-category-next-info').addClass('step-button-disabled');
                
                $('#step-top-4').removeAttr('onclick');
            }
        });
        
        $("#specific_task").focusout(function(){
            var jobTitle = $('#jobTitle').val();
            var specific_task = $('#specific_task').val();
            var proof = $('#proof').val();
            if(jobTitle !== "" && specific_task !== "" && proof !== ""){
                $('#step-button-category-next-info').prop('disabled', false);
                $('#step-button-category-next-info').removeClass('step-button-disabled');
                
                $('#step-top-4').attr('onClick', 'nextStep(4);');
            }else {
                $('#step-button-category-next-info').prop('disabled', true);
                $('#step-button-category-next-info').addClass('step-button-disabled');
                
                $('#step-top-4').removeAttr('onclick');
            }
        });
        
        $("#proof").focusout(function(){
            var jobTitle = $('#jobTitle').val();
            var specific_task = $('#specific_task').val();
            var proof = $('#proof').val();
            if(jobTitle !== "" && specific_task !== "" && proof !== ""){
                $('#step-button-category-next-info').prop('disabled', false);
                $('#step-button-category-next-info').removeClass('step-button-disabled');
                
                $('#step-top-4').attr('onClick', 'nextStep(4);');
            }else {
                $('#step-button-category-next-info').prop('disabled', true);
                $('#step-button-category-next-info').addClass('step-button-disabled');
                
                $('#step-top-4').removeAttr('onclick');
            }
        });
        
        function updateCharCount() {
            var textarea = document.getElementById('specific_task');
            var charCountSpan = document.getElementById('charCount');
            charCountSpan.textContent = textarea.value.length;
        }
    
        function limitTextarea(element, maxLength) {
            const value = element.value;
            if (value.length > maxLength) {
                element.value = value.substring(0, maxLength);
            }
        }
        
        function limitInput(element, maxLength) {
            const value = element.value;
            if (value.length > maxLength) {
                element.value = value.substring(0, maxLength);
            }
         }

        function checkBalance() {
            var old_required_screenshots_cost = parseFloat($('#old_required_screenshots_cost').val());
            var job_fee = parseInt($('#job_fee').val());
            var worker_need = parseFloat($('#worker_need').val());
            var each_worker_earn = parseFloat($('#each_worker_earn').val());
        
            var each_worker_min_earn = parseFloat($('#each_worker_min_earn').val()) || 0;
        
            var total_cost = parseFloat(each_worker_earn * worker_need);
            var fee = parseFloat((parseFloat(total_cost) * parseFloat(job_fee)) / 100);
            var total = (total_cost + fee + old_required_screenshots_cost).toFixed(4);
            $('#budget').val(total);
        
            var budget = parseFloat($('#budget').val());
            var depositBalance = parseFloat('{{ Auth::user()->deposit_balance }}');
            var minimum_cost = parseFloat($('#minimum_cost').val());
            var $depoButton = $('#postInfo'); 
        
            if (budget < minimum_cost) {
                $('#budget').addClass('over-balance');
                $('#postSubmitNew').prop('disabled', true);
                $('#inWorker').fadeIn();
                $('#mCost').show();
            } else if (budget > depositBalance) {
                $('#budget').addClass('over-balance');
                $('#postSubmitNew').prop('disabled', true);
                $('#inWorker').hide();
                $('#mCost').hide();
                $('#postInfo').show();
            } else if (each_worker_earn < each_worker_min_earn) {
                $('#postSubmitNew').prop('disabled', true);
            } else {
                $('#budget').removeClass('over-balance');
                $('#postSubmitNew').prop('disabled', false);
                $('#inWorker').hide();
                $('#mCost').hide();
                $('#postInfo').hide();
            }
        }
        
        $('#old_required_screenshots_cost, #job_fee, #worker_need, #each_worker_earn, #each_worker_min_earn').on('input', function () {
            checkBalance();
        });
        
        $(document).ready(function () {
            checkBalance();
        });
        
        function closeThisMessage() {
            var successMessage = document.getElementById('jobSuccessMessage');
            var errorMessage = document.getElementById('jobErrorMessage');
    
            if (successMessage) {
                successMessage.parentNode.style.display = 'none';
            }
    
            if (errorMessage) {
                errorMessage.parentNode.style.display = 'none';
            }
        }
        function readURL(){
            var file = $('#screen_shot_select_image').get(0).files[0];
            console.log(file);
            if(file){
            $('#screen_shot_show_image').show();
            var reader = new FileReader();
            
            reader.onload = function(){
            $('#screen_shot_show_image').attr("src", reader.result);
            }
            
            reader.readAsDataURL(file);
            }
        }
        
        function readURL() {
            var file = $('#screen_shot_select_image').get(0).files[0];
            var errorElement = document.getElementById('file-error');
            
            if (file) {
                // Check file size (max 1MB)
                if (file.size > 1048576) { // 1048576 bytes = 1MB
                    errorElement.textContent = "File size must be less than or equal to 1MB.";
                    $('#screen_shot_select_image').val(''); // Clear the input
                    $('#screen_shot_show_image').hide(); // Hide the image preview
                    return;
                } else {
                    errorElement.textContent = ""; // Clear error message
                }
    
                // Show image preview
                $('#screen_shot_show_image').show();
                var reader = new FileReader();
    
                reader.onload = function () {
                    $('#screen_shot_show_image').attr("src", reader.result);
                }
    
                reader.readAsDataURL(file);
            }
        }
        
    </script>
@endsection
